using UnityEngine;
using UnityEngine.UI;
using System.Collections;
using System.Collections.Generic;
using System.IO;
using System;
using UnityEngine.Audio;
public class EnhancedBackgroundMusic : MonoBehaviour
{
    public AudioClip[] BGM = new AudioClip[10];
    public AudioSource AudioSrc;
    public byte previousFrameSong = 0;
    public string persistentDataPath;
    public string currentRomName;

    public IEnumerator OnScriptLoaded()
    {
        persistentDataPath = Application.dataPath + "/../";
        currentRomName = RxScriptInit.currentRomName;
        AudioSrc = GameObject.Find("Main Camera").AddComponent<AudioSource>();
        AudioSrc.playOnAwake = false;
        
            if (File.Exists(persistentDataPath + "/Enhancements/" + currentRomName + "/-MyPackage-/BGM/BGM_GroundMusic.ogg") == true)
            {
                WWW www = new WWW("file:///" + persistentDataPath + "/Enhancements/" + currentRomName + "/-MyPackage-/BGM/BGM_GroundMusic.ogg");
                yield return www;
                BGM[1] = www.GetAudioClip(false);
            }
        if (File.Exists(persistentDataPath + "/Enhancements/" + currentRomName + "/-MyPackage-/BGM/BGM_WaterMusic.ogg") == true)
        {
            WWW www = new WWW("file:///" + persistentDataPath + "/Enhancements/" + currentRomName + "/-MyPackage-/BGM/BGM_WaterMusic.ogg");
            yield return www;
            BGM[2] = www.GetAudioClip(false);
        }
        if (File.Exists(persistentDataPath + "/Enhancements/" + currentRomName + "/-MyPackage-/BGM/BGM_UndergroundMusic.ogg") == true)
        {
            WWW www = new WWW("file:///" + persistentDataPath + "/Enhancements/" + currentRomName + "/-MyPackage-/BGM/BGM_UndergroundMusic.ogg");
            yield return www;
            BGM[3] = www.GetAudioClip(false);
        }
        if (File.Exists(persistentDataPath + "/Enhancements/" + currentRomName + "/-MyPackage-/BGM/BGM_CastleMusic.ogg") == true)
        {
            WWW www = new WWW("file:///" + persistentDataPath + "/Enhancements/" + currentRomName + "/-MyPackage-/BGM/BGM_CastleMusic.ogg");
            yield return www;
            BGM[4] = www.GetAudioClip(false);
        }
        if (File.Exists(persistentDataPath + "/Enhancements/" + currentRomName + "/-MyPackage-/BGM/BGM_CloudMusic.ogg") == true)
        {
            WWW www = new WWW("file:///" + persistentDataPath + "/Enhancements/" + currentRomName + "/-MyPackage-/BGM/BGM_CloudMusic.ogg");
            yield return www;
            BGM[5] = www.GetAudioClip(false);
        }
        if (File.Exists(persistentDataPath + "/Enhancements/" + currentRomName + "/-MyPackage-/BGM/BGM_PipeIntroMusic.ogg") == true)
        {
            WWW www = new WWW("file:///" + persistentDataPath + "/Enhancements/" + currentRomName + "/-MyPackage-/BGM/BGM_PipeIntroMusic.ogg");
            yield return www;
            BGM[6] = www.GetAudioClip(false);
        }
        if (File.Exists(persistentDataPath + "/Enhancements/" + currentRomName + "/-MyPackage-/BGM/BGM_StarPowerMusic.ogg") == true)
        {
            WWW www = new WWW("file:///" + persistentDataPath + "/Enhancements/" + currentRomName + "/-MyPackage-/BGM/BGM_StarPowerMusic.ogg");
            yield return www;
            BGM[7] = www.GetAudioClip(false);
        }
    }

    public void Update()
    {
       
        if (MyNes.NesEmu.mem_wram != null)
        {
            if (MyNes.NesEmu.mem_wram[244] != previousFrameSong && MyNes.NesEmu.mem_wram[244] != 0)
            {
                UnityEngine.Debug.Log("Music = " + MyNes.NesEmu.mem_wram[244]);
                previousFrameSong = MyNes.NesEmu.mem_wram[244];
                if (MyNes.NesEmu.mem_wram[244] == 1) // GroundMusic
                {
                    AudioSrc.Stop();
                    AudioSrc.clip = BGM[1];
                    AudioSrc.Play();
                    AudioSrc.loop = true;
                }
                else if (MyNes.NesEmu.mem_wram[244] == 2)  // WaterMusic
                {
                    AudioSrc.Stop();
                    AudioSrc.clip = BGM[2];
                    AudioSrc.Play();
                    AudioSrc.loop = true;
                }
                else if (MyNes.NesEmu.mem_wram[244] == 4)// UndergroundMusic
                {
                    AudioSrc.Stop();
                    AudioSrc.clip = BGM[3];
                    AudioSrc.Play();
                    AudioSrc.loop = true;
                }
                else if (MyNes.NesEmu.mem_wram[244] == 8) // CastleMusic
                {
                    AudioSrc.Stop();
                    AudioSrc.clip = BGM[4];
                    AudioSrc.Play();
                    AudioSrc.loop = true;
                }
                else if (MyNes.NesEmu.mem_wram[244] == 16) // CloudMusic
                {
                    AudioSrc.Stop();
                    AudioSrc.clip = BGM[5];
                    AudioSrc.Play();
                    AudioSrc.loop = true;
                }
                else if (MyNes.NesEmu.mem_wram[244] == 32) // PipeIntroMusic
                {
                    AudioSrc.Stop();
                    AudioSrc.clip = BGM[6];
                    AudioSrc.Play();
                    AudioSrc.loop = true;
                }
                else if (MyNes.NesEmu.mem_wram[244] == 64) // StarPowerMusic
                {
                    AudioSrc.Stop();
                    AudioSrc.clip = BGM[7];
                    AudioSrc.Play();
                    AudioSrc.loop = true;
                }
            }
            MyNes.NesEmu.mem_wram[244] = 0; // Silence
            MyNes.NesEmu.mem_wram[1882] = 2;
        }
    }
}